#ifndef _TABSECURITY_H
#define _TABSECURITY_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"

#include "../Source/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Init.H"
#include "../Source/WinService.H"
#include "../Source/Routines.H"

#include "../SockServer/SockServer.H"

#include "../Dialogs/MainDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabSecurityDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND AuthString_hWnd;
    static HWND AuthKey_hWnd;
    static HWND EncryptKeyLength_hWnd;
    static HWND AdminPassword1_hWnd;
    static HWND AdminPassword2_hWnd;

    if(xMessage == WM_INITDIALOG)
    {
        AuthString_hWnd        = GetDlgItem(xHandle, IDC_AUTHSTRING);
        AuthKey_hWnd           = GetDlgItem(xHandle, IDC_AUTHKEY);
        EncryptKeyLength_hWnd  = GetDlgItem(xHandle, IDC_ENCRYPTKEYLEN);
        AdminPassword1_hWnd    = GetDlgItem(xHandle, IDC_ADMINPASSWORD1);
        AdminPassword2_hWnd    = GetDlgItem(xHandle, IDC_ADMINPASSWORD2);

		Set_Text(AuthString_hWnd, gsAuthString);
        Set_Text(AuthKey_hWnd, gsAuthKey);
		Set_Long(EncryptKeyLength_hWnd, giKeyGenLength);

        return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
